/**************************** XS ********************************************
Copyright (C) 2000-2024  P. Bergman

This program is free software; you can redistribute it and/or modify it under 
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
*****************************************************************************/
#ifndef LIST_H
#include "list.h"
#endif

#ifndef MENUS_H
#include "menus.h"
#endif

void  get_file(Widget, char *, XtPointer);
void  set_file(Widget, char *, XtPointer);
void  set_PS_file(Widget, char *, XtPointer);
void  get_scales(Widget, char *, XtPointer);
void  toggle_any(Widget, XtPointer, XtPointer);
void  set_show_mode(Widget, char *, XtPointer);
void  redraw_graph(Widget, char *, XtPointer);
void  gauss_reset(Widget, char *, XtPointer);
void  box_reset(Widget, char *, XtPointer);
void  mark_reset(Widget, char *, XtPointer);
void  channel_mod(Widget, char *, XtPointer);
void  mod_reset(Widget, char *, XtPointer);
void  PostDespikeDialog(Widget, char *, XtPointer);
void  new_gaussian(Widget, char *, XtPointer), new_box(Widget, char *, XtPointer);
void  do_fit(Widget, char *, XtPointer), do_baseline_fit(Widget, char *, XtPointer);
void  reset_bl_parameters(Widget, char *, XtPointer);
void  SetRmsFromBoxes(Widget, char *, XtPointer);
void  remove_poly(Widget, char *, XtPointer);
void  add_poly(Widget, char *, XtPointer);
void  interpolate_from_poly(Widget, char *, XtPointer);
void  PolynomialOrderDialog(Widget, char *, XtPointer);
void  GaussiansToMarkers(Widget, char *, XtPointer);
void  MathSelectedGaussian(Widget, char *, XtPointer);
void  open_freq_file(Widget, char *, XtPointer);
void  PostVLSRDialog(Widget, char *, XtPointer);
void  PostImageFreqDialog(Widget, char *, XtPointer);
void  PostShiftDialog(Widget, char *, XtPointer);
void  PostVelShiftDialog(Widget, char *, XtPointer);
void  obtain_map_info(Widget, char *, XtPointer);
void  PostManualContourDialog(Widget, char *, XtPointer);
void  PostRangeStepContourDialog(Widget, char *, XtPointer);
void  PostContourDialog(Widget, char *, XtPointer);
void  do_quit(Widget, char *, XtPointer);
void  AverageScans(Widget, char *, XtPointer);
void  scale_scans(Widget, char *, XtPointer);
void  smooth_scans(Widget, char *, XtPointer);
void  redres_scans(Widget, char *, XtPointer);
void  invert_scans(Widget, char *, XtPointer);
void  FoldSelect(Widget, char *, XtPointer);
void  do_fft(Widget, char *, XtPointer);
void  do_cor(Widget, char *, XtPointer);
void  swap_spectrum_and_rms(Widget, char *, XtPointer);
void  store_current_map(Widget, char *, XtPointer);
void  StoreMultipleMaps();
void  StoreCurrentScatter();
void  manipulate_maps();
void  manipulate_datasets();
void  manipulate_spectra();
void  manipulate_scats();
void  ScatterPointOps();
void  manipulate_sources();
list *get_maplist();
list *get_scatterlist();
list *get_listlist();
void  MapDraw(Widget, MAP *, XmListCallbackStruct *);
void  ScatterDraw(Widget, scatter *, XmListCallbackStruct *);
void  SelectDataSet();
void  PostScatterOptionDialog();
void  MakeSingleSpeScatterPlot();
void  AdjustScale(Widget, char *, XtPointer);
void  InvertScale(Widget, char *, XtPointer);
void  MenuSavePrefsFile();
#ifdef APEX
void  EditHoloFit();
void  EditHoloData();
void  EditAPEXMap();
#endif
void  EditPrefsFile();
void  ViewPrefsFile();
void  PrintPostScriptFile();
void  ShowPostScriptFile();
void  DoMenuZoom();
void  ScaleMarkers();
void  DoClipScans();
void  PostFilterDialog(Widget, char *, XtPointer);
void  ViewCurrentMapAsScatterPlot();
void  PostScatterTypeDialog(Widget, char *, XtPointer);
void  FitAllGaussians();
void  PostSubMapDialog(Widget, char *, XtPointer);
void  PostLabelDialog(Widget, char *, XtPointer);
void  PostModifyHeaderDialog(Widget, char *, XtPointer);
void  AttachContToMap();
void  AttachBoxesToDataset();
void  PostMapTypeDialog();
void  GaussViewer();
void  PostCoordDialog(Widget, char *, XtPointer);
void  PostPreDialog(Widget, char *, XtPointer);
void  PostTestMapDialog(Widget, char *, XtPointer);
void  PostMacroEditDialog(Widget, char *, XtPointer);
void  Post2DimFitDialog(Widget, Gauss2D *, XtPointer);
void  ExecuteMacro();
void  EditCurrentBaselineParameters();
void  PostDotDialog(Widget, char *, XtPointer);
void  GaussModeDialog();
void  PostPolyCircleDialog(Widget, char *, XtPointer);
void  MenuDeletePolyLines();
void  AttachScale();
/* Help menu functions */
void  About();
void  Version();
void  ReadMe();
void  ProblemsAndBugs();
void  WhatsNew();
void  Help();

/*** File Menu Items ***/
MenuItem OpenNativeFileMenuData[] = {
   {"Open primary...", &xmPushButtonGadgetClass,
    XK_p, "Ctrl<Key>O", "Ctrl+O", False, NULL, get_file, "read", NULL},
   {"Open secondary...", &xmPushButtonGadgetClass,
    XK_s, "Ctrl<Key>2", "Ctrl+2", False, NULL, get_file, "secondary", NULL},
EOI};

MenuItem OpenFitsFileMenuData[] = {
   {"Open single...", &xmPushButtonGadgetClass,
    XK_s, "Ctrl<Key>F", "Ctrl+F", False, NULL, get_file, "fits", NULL},
   {"Open multiple (map)...", &xmPushButtonGadgetClass,
    XK_m, "Ctrl<Key>M", "Ctrl+M", False, NULL, get_file, "mapfits", NULL},
   {"Open sequence...", &xmPushButtonGadgetClass,
    XK_q, "Ctrl<Key>S", "Ctrl+S", False, NULL, get_file, "seqfits", NULL},
   {"Append to multiple...", &xmPushButtonGadgetClass,
    XK_a, NULL, NULL, False, NULL, get_file, "appmapfits", NULL},
   {"Append to sequence...", &xmPushButtonGadgetClass,
    XK_p, NULL, NULL, False, NULL, get_file, "appseqfits", NULL},
 MENUSEPARATOR,
   {"Open FITS array...", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, get_file, "2dfits", NULL},
   {"Open FITS cube...", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, get_file, "3dfits", NULL},
 MENUSEPARATOR,
   {"Open binary table as multiple...", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, get_file, "bintab", NULL},
   {"Open binary table as sequence...", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, get_file, "seqbintab", NULL},
EOI};

MenuItem OpenClassFileMenuData[] = {
   {"Open CLASS file...", &xmPushButtonGadgetClass,
    XK_s, NULL, NULL, False, NULL, get_file, "class", NULL},
EOI};

MenuItem OpenDrpFileMenuData[] = {
   {"Open single...", &xmPushButtonGadgetClass,
    XK_s, NULL, NULL, False, NULL, get_file, "drp", NULL},
   {"Open multiple (map)...", &xmPushButtonGadgetClass,
    XK_m, NULL, NULL, False, NULL, get_file, "mapdrp", NULL},
   {"Open sequence...", &xmPushButtonGadgetClass,
    XK_q, NULL, NULL, False, NULL, get_file, "seqdrp", NULL},
   {"Append to multiple...", &xmPushButtonGadgetClass,
    XK_a, NULL, NULL, False, NULL, get_file, "appmapdrp", NULL},
   {"Append to sequence...", &xmPushButtonGadgetClass,
    XK_p, NULL, NULL, False, NULL, get_file, "appseqdrp", NULL},
EOI};

MenuItem OpenAntsFileMenuData[] = {
   {"Open single...", &xmPushButtonGadgetClass,
    XK_s, NULL, NULL, False, NULL, get_file, "ants", NULL},
   {"Open single (2nd receiver)...", &xmPushButtonGadgetClass,
    XK_i, NULL, NULL, False, NULL, get_file, "ants2", NULL},
   {"Open multiple...", &xmPushButtonGadgetClass,
    XK_m, NULL, NULL, False, NULL, get_file, "mapants", NULL},
   {"Open multiple (2nd receiver)...", &xmPushButtonGadgetClass,
    XK_u, NULL, NULL, False, NULL, get_file, "mapants2", NULL},
   {"Open sequence...", &xmPushButtonGadgetClass,
    XK_s, NULL, NULL, False, NULL, get_file, "seqants", NULL},
   {"Open sequence (2nd receiver)...", &xmPushButtonGadgetClass,
    XK_e, NULL, NULL, False, NULL, get_file, "seqants2", NULL},
   {"Append multiple...", &xmPushButtonGadgetClass,
    XK_m, NULL, NULL, False, NULL, get_file, "appmapants", NULL},
   {"Append multiple (2nd receiver)...", &xmPushButtonGadgetClass,
    XK_u, NULL, NULL, False, NULL, get_file, "appmapants2", NULL},
   {"Append sequence...", &xmPushButtonGadgetClass,
    XK_s, NULL, NULL, False, NULL, get_file, "appseqants", NULL},
   {"Append sequence (2nd receiver)...", &xmPushButtonGadgetClass,
    XK_e, NULL, NULL, False, NULL, get_file, "appseqants2", NULL},
EOI};

MenuItem SaveBTFitsFileMenuData[] = {
  {"Odin format", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, set_file, "wbintab_Odin", NULL},
EOI};

MenuItem SaveFitsFileMenuData[] = {
  {"Save single FITS...", &xmPushButtonGadgetClass,
   XK_i, NULL, NULL, False, NULL, set_file, "fwrite", NULL},
  {"Save FITS array...", &xmPushButtonGadgetClass,
   XK_a, NULL, NULL, False, NULL, set_file, "f2Dwrite", NULL},
  {"Save FITS cube...", &xmPushButtonGadgetClass,
   XK_c, NULL, NULL, False, NULL, set_file, "f3Dwrite", NULL},
  {"Save multiple FITS...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, set_file, "mfwrite", NULL},
 MENUSEPARATOR,
  {"Save dataset as FITS binary table using", &xmCascadeButtonGadgetClass,
   XK_F, NULL, NULL, True, NULL, NULL, NULL, SaveBTFitsFileMenuData},
EOI};

MenuItem OpenFreqFileMenuData[] = {
   {"SLAIM...", &xmPushButtonGadgetClass,
    XK_S, NULL, NULL, False, NULL, open_freq_file, "SLAIM", NULL},
   {"Lovas...", &xmPushButtonGadgetClass,
    XK_L, NULL, NULL, False, NULL, open_freq_file, "LOVAS", NULL},
   {"JPL...", &xmPushButtonGadgetClass,
    XK_J, NULL, NULL, False, NULL, open_freq_file, "JPL", NULL},
   {"CDMS...", &xmPushButtonGadgetClass,
    XK_C, NULL, NULL, False, NULL, open_freq_file, "CDMS", NULL},
EOI};

MenuItem PrintPSFileMenuData[] = {
   {"PS landscape", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, PrintPostScriptFile, "ps", NULL},
   {"PS portrait", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, PrintPostScriptFile, "vps", NULL},
   {"Color PS landscape", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, PrintPostScriptFile, "cps", NULL},
   {"Color PS portrait", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, PrintPostScriptFile, "vcps", NULL},
EOI};

MenuItem SavePSFileMenuData[] = {
   {"PS landscape", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, set_PS_file, "ps", NULL},
   {"PS portrait", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, set_PS_file, "vps", NULL},
   {"Color PS landscape", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, set_PS_file, "cps", NULL},
   {"Color PS portrait", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, set_PS_file, "vcps", NULL},
EOI};

MenuItem FileMenuData[] = {
  {"Open native", &xmCascadeButtonGadgetClass,
   XK_O, NULL, NULL, True, NULL, NULL, NULL, OpenNativeFileMenuData},
  {"Open FITS", &xmCascadeButtonGadgetClass,
   XK_F, NULL, NULL, True, NULL, NULL, NULL, OpenFitsFileMenuData},
  {"Open CLASS", &xmCascadeButtonGadgetClass,
   XK_C, NULL, NULL, True, NULL, NULL, NULL, OpenClassFileMenuData},
  {"Open DRP", &xmCascadeButtonGadgetClass,
   XK_D, NULL, NULL, True, NULL, NULL, NULL, OpenDrpFileMenuData},
  {"Open POPS", &xmCascadeButtonGadgetClass,
   XK_P, NULL, NULL, True, NULL, NULL, NULL, OpenAntsFileMenuData},
 MENUSEPARATOR,
  {"Set FITS/DRP/CLASS filter...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, PostFilterDialog, NULL, NULL},
  {"Modify header...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, PostModifyHeaderDialog, NULL, NULL},
 MENUSEPARATOR,
  {"Open frequency file", &xmCascadeButtonGadgetClass,
   XK_q, NULL, NULL, True, NULL, NULL, NULL, OpenFreqFileMenuData},
#ifdef APEX
  {"Open holography file...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, get_file, "rholo", NULL},
  {"Open APEX map file...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, get_file, "rapex", NULL},
#endif
 MENUSEPARATOR,
  {"Open scatter...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, get_file, "rsca", NULL},
  {"Save scatter...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, set_file, "wsca", NULL},
 MENUSEPARATOR,
  {"Open graphical state...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, get_file, "rstate", NULL},
  {"Save graphical state...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, set_file, "wstate", NULL},
 MENUSEPARATOR,
  {"Save native...", &xmPushButtonGadgetClass,
   XK_S, NULL, NULL, False, NULL, set_file, "write", NULL},
  {"Save FITS", &xmCascadeButtonGadgetClass,
   XK_F, NULL, NULL, True, NULL, NULL, NULL, SaveFitsFileMenuData},
 MENUSEPARATOR,
  {"Save current spectra as ASCII table...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, set_file, "spetable", NULL},
  {"Save current map as ASCII table...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, set_file, "maptable", NULL},
  {"Save current scatter plot as ASCII table...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, set_file, "scatable", NULL},
#ifdef HAVE_LIBPGPLOT
 MENUSEPARATOR,
  {"Show PostScript file", &xmPushButtonGadgetClass,
   XK_VoidSymbol, "Ctrl<Key>P", "Ctrl+P", False, NULL, ShowPostScriptFile, "xwin", NULL},
  {"Save PostScript file...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, NULL, NULL, SavePSFileMenuData},
  {"Print PostScript file", &xmCascadeButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, True, NULL, NULL, NULL, PrintPSFileMenuData},
#endif
 MENUSEPARATOR,
  {"Exit", &xmPushButtonGadgetClass,
   XK_x, "Ctrl<Key>Q", "Ctrl+Q", False, NULL, do_quit, "quit", NULL},
EOI};


/*** Graph Menu Items ***/

MenuItem ZoomMenuData[] = {
  {"Zoom x2.0", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, DoMenuZoom, "bin", NULL},
  {"Zoom only X x2.0", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, DoMenuZoom, "xin", NULL},
  {"Zoom only Y x2.0", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, DoMenuZoom, "yin", NULL},
  {"Zoom x0.5", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, DoMenuZoom, "bout", NULL},
  {"Zoom only X x0.5", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, DoMenuZoom, "xout", NULL},
  {"Zoom only Y x0.5", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, DoMenuZoom, "yout", NULL},
EOI};

MenuItem DefaultscaleMenuData[] = {
  {"x-axis", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, AdjustScale, "x", NULL},
  {"y-axis", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, AdjustScale, "y", NULL},
EOI};

MenuItem InvertMenuData[] = {
  {"x-axis", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, InvertScale, "x", NULL},
  {"y-axis", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, InvertScale, "y", NULL},
EOI};

CallbackData GMD_Xfixed = {NULL, "xfixed", &(view.fixed_x), NULL};
CallbackData GMD_Yfixed = {NULL, "yfixed", &(view.fixed_y), NULL};
CallbackData GMD_Zfixed = {NULL, "zfixed", &(view.fixed_z), NULL};
CallbackData GMD_Xauto = {NULL, "xauto", &(view.autoscale_x), NULL};
CallbackData GMD_Yauto = {NULL, "yauto", &(view.autoscale_y), NULL};
CallbackData GMD_attach = {NULL, "attached", &(view.use_attached_frame), NULL};

MenuItem FreezescaleMenuData[] = {
  {"x-scale", &xmToggleButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, toggle_any, (XtPointer)&GMD_Xfixed, NULL},
  {"y-scale", &xmToggleButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, toggle_any, (XtPointer)&GMD_Yfixed, NULL},
EOI};

MenuItem AutoscaleMenuData[] = {
  {"x-axis", &xmToggleButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, toggle_any, (XtPointer)&GMD_Xauto, NULL},
  {"y-axis", &xmToggleButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, toggle_any, (XtPointer)&GMD_Yauto, NULL},
EOI};

int SecondSpectrum = 2;
int AllSpectra = 3;

CallbackData TMD_Clear   = {NULL, "clear",   &draw.clear,     NULL};
CallbackData TMD_Update  = {NULL, "update",  &draw.update,    NULL};
CallbackData TMD_Data    = {NULL, "data",    &draw.data,      NULL};
CallbackData TMD_Rms     = {NULL, "rms",     &draw.data_rms,  NULL};
CallbackData TMD_Secone  = {NULL, "sec",     &draw.data_sec, &SecondSpectrum};
CallbackData TMD_Secall  = {NULL, "all",     &draw.data_sec, &AllSpectra};
CallbackData TMD_Frame   = {NULL, "frame",   &draw.frame,     NULL};
CallbackData TMD_WFrame  = {NULL, "Wframe",  &draw.wframe,    NULL};
CallbackData TMD_Labels  = {NULL, "labels",  &draw.labels,    NULL};
CallbackData TMD_WLabels = {NULL, "Wlabels", &draw.wlabels,   NULL};
CallbackData TMD_Ticks   = {NULL, "ticks",   &draw.ticks,     NULL};
CallbackData TMD_WTicks  = {NULL, "Wticks",  &draw.wticks,    NULL};
CallbackData TMD_Markers = {NULL, "markers", &draw.markers,   NULL};
CallbackData TMD_Histo   = {NULL, "histo",   &draw.histo,     NULL};
CallbackData TMD_SHisto  = {NULL, "shisto",  &draw.histo_sec, NULL};
CallbackData TMD_Zline   = {NULL, "zline",   &draw.zline,     NULL};
CallbackData TMD_Boxes   = {NULL, "boxes",   &draw.boxes,     NULL};
CallbackData TMD_Poly    = {NULL, "poly",    &draw.poly,      NULL};
CallbackData TMD_Gsum    = {NULL, "gsum",    &draw.gsum,      NULL};
CallbackData TMD_Gind    = {NULL, "gind",    &draw.gind,      NULL};
CallbackData TMD_XEbars  = {NULL, "xebars",  &draw.xebars,    NULL};
CallbackData TMD_YEbars  = {NULL, "yebars",  &draw.yebars,    NULL};
CallbackData TMD_PAxes   = {NULL, "paxes",   &draw.projaxes,  NULL};
CallbackData TMD_PNums   = {NULL, "pnums",   &draw.projnums,  NULL};
CallbackData TMD_Mult    = {NULL, "mult",    &draw.multiple,  NULL};
CallbackData TMD_Header  = {NULL, "header",  &draw.header,    NULL};

MenuItem ToggleMenuData[] = {
  {"Toggle window clear", &xmToggleButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, toggle_any, (XtPointer)&TMD_Clear, NULL},
  {"Toggle auto-updating", &xmToggleButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, toggle_any, (XtPointer)&TMD_Update, NULL},
  {"Toggle header", &xmToggleButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, toggle_any, (XtPointer)&TMD_Header, NULL},
  {"Toggle data", &xmToggleButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, toggle_any, (XtPointer)&TMD_Data, NULL},
  {"Toggle RMS", &xmToggleButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, toggle_any, (XtPointer)&TMD_Rms, NULL},
  {"Toggle secondary", &xmToggleButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, toggle_any, (XtPointer)&TMD_Secone, NULL},
  {"Toggle all as secs.", &xmToggleButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, toggle_any, (XtPointer)&TMD_Secall, NULL},
  {"Toggle frame", &xmToggleButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, toggle_any, (XtPointer)&TMD_Frame, NULL},
  {"Toggle labels", &xmToggleButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, toggle_any, (XtPointer)&TMD_Labels, NULL},
  {"Toggle tick marks", &xmToggleButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, toggle_any, (XtPointer)&TMD_Ticks, NULL},
  {"Toggle markers", &xmToggleButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, toggle_any, (XtPointer)&TMD_Markers, NULL},
  {"Toggle line/histo", &xmToggleButtonGadgetClass, XK_h, "Ctrl<Key>H",
   "Ctrl+H", False, NULL, toggle_any, (XtPointer)&TMD_Histo, NULL},
  {"Toggle sec. line/histo", &xmToggleButtonGadgetClass, XK_VoidSymbol, NULL,
   NULL, False, NULL, toggle_any, (XtPointer)&TMD_SHisto, NULL},
  {"Toggle zero line", &xmToggleButtonGadgetClass, XK_z, "Ctrl<Key>Z",
   "Ctrl+Z", False, NULL, toggle_any, (XtPointer)&TMD_Zline, NULL},
  {"Toggle boxes", &xmToggleButtonGadgetClass, XK_x, "Ctrl<Key>X",
   "Ctrl+X", False, NULL, toggle_any, (XtPointer)&TMD_Boxes, NULL},
  {"Toggle poly. fit", &xmToggleButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, toggle_any, (XtPointer)&TMD_Poly, NULL},
  {"Toggle Gauss sum", &xmToggleButtonGadgetClass,
   XK_G, NULL, NULL, False, NULL, toggle_any, (XtPointer)&TMD_Gsum, NULL},
  {"Toggle Gauss ind.", &xmToggleButtonGadgetClass,
   XK_i, NULL, NULL, False, NULL, toggle_any, (XtPointer)&TMD_Gind, NULL},
  {"Toggle wedge frame", &xmToggleButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, toggle_any, (XtPointer)&TMD_WFrame, NULL},
  {"Toggle wedge labels", &xmToggleButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, toggle_any, (XtPointer)&TMD_WLabels, NULL},
  {"Toggle wedge tick marks", &xmToggleButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, toggle_any, (XtPointer)&TMD_WTicks, NULL},
  {"Toggle scatter overlay", &xmToggleButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, toggle_any, (XtPointer)&TMD_Mult, NULL},
  {"Toggle X error bars", &xmToggleButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, toggle_any, (XtPointer)&TMD_XEbars, NULL},
  {"Toggle Y error bars", &xmToggleButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, toggle_any, (XtPointer)&TMD_YEbars, NULL},
  {"Toggle proj. axes", &xmToggleButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, toggle_any, (XtPointer)&TMD_PAxes, NULL},
  {"Toggle proj. numbers", &xmToggleButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, toggle_any, (XtPointer)&TMD_PNums, NULL},
EOI};

MenuItem ShowModeMenuData[] = {
  {"Single spectrum", &xmPushButtonGadgetClass,
   XK_S, "Alt<Key>1", "Alt+1", False, NULL, set_show_mode, "single", NULL},
  {"Multiple spectra", &xmPushButtonGadgetClass,
   XK_M, "Alt<Key>2", "Alt+2", False, NULL, set_show_mode, "map", NULL},
  {"Pos&Pos Contour map", &xmPushButtonGadgetClass,
   XK_P, "Alt<Key>3", "Alt+3", False, NULL, set_show_mode, "contour", NULL},
  {"Vel&Pos contour map", &xmPushButtonGadgetClass,
   XK_V, "Alt<Key>4", "Alt+4", False, NULL, set_show_mode, "velpos", NULL},
  {"Scatter plot", &xmPushButtonGadgetClass,
   XK_c, "Alt<Key>5", "Alt+5", False, NULL, set_show_mode, "scatter", NULL},
EOI};

MenuItem DotMarkerData[] = {
  {"In maps...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, PostDotDialog, "mapdot", NULL},
  {"In scatter plots...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, PostDotDialog, "scatterdot", NULL},
EOI};

MenuItem ManualContourData[] = {
  {"Manually...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, PostManualContourDialog, "menu", NULL},
  {"As range/step...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, PostRangeStepContourDialog, "menu", NULL},
EOI};

MenuItem GraphMenuData[] = {
  {"Redraw graph", &xmPushButtonGadgetClass,
   XK_R, "Ctrl<Key>R", "Ctrl+R", False, NULL, redraw_graph, "redraw", NULL},
  {"Update graph", &xmPushButtonGadgetClass,
   XK_U, "Ctrl<Key>U", "Ctrl+U", False, NULL, redraw_graph, "update", NULL},
 MENUSEPARATOR,
  {"Zoom options", &xmCascadeButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, True, NULL, NULL, NULL, ZoomMenuData},
  {"Freeze the", &xmCascadeButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, True, NULL, NULL, NULL, FreezescaleMenuData},
  {"Default scaling of", &xmCascadeButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, True, NULL, NULL, NULL, DefaultscaleMenuData},
  {"Temporarily invert", &xmCascadeButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, True, NULL, NULL, NULL, InvertMenuData},
  {"Change scales...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, get_scales, "Rescale", NULL},
 MENUSEPARATOR,
  {"Attach current scaling", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, AttachScale, "Attach", NULL},
  {"Detach scaling", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, AttachScale, "Detach", NULL},
 MENUSEPARATOR,
  {"Set size of multiple plot...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, PostSubMapDialog, "nxny", NULL},
  {"Autoscale in mult. plots", &xmCascadeButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, True, NULL, NULL, NULL, AutoscaleMenuData},
  {"Use attached scales if any", &xmToggleButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, toggle_any, (XtPointer)&GMD_attach, NULL},
 MENUSEPARATOR,
  {"Type of labels...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, PostLabelDialog, "label", NULL},
  {"Graph options", &xmCascadeButtonGadgetClass,
   XK_G, NULL, NULL, True, NULL, NULL, NULL, ToggleMenuData},
  {"Dot markers", &xmCascadeButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, True, NULL, NULL, NULL, DotMarkerData},
 MENUSEPARATOR,
  {"Viewing modes", &xmCascadeButtonGadgetClass,
   XK_S, NULL, NULL, True, NULL, NULL, NULL, ShowModeMenuData},
  {"Type of map...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, PostMapTypeDialog, NULL, NULL},
  {"Show map info", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, obtain_map_info, "info", NULL},
 MENUSEPARATOR,
  {"Freeze contour levels", &xmToggleButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, toggle_any, (XtPointer)&GMD_Zfixed, NULL},
  {"Set contour levels", &xmCascadeButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, True, NULL, NULL, NULL, ManualContourData},
  {"Contour levels...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, PostContourDialog, "menu", NULL},
EOI};


/*** Gauss Menu Items ***/

MenuItem RemoveGaussMenuData[] = {
  {"All", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, gauss_reset, "all", NULL},
  {"All map Gaussians", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, gauss_reset, "mapall", NULL},
  {"Last", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, gauss_reset, "latest", NULL},
  {"with cursor", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, gauss_reset, "cursor", NULL},
EOI};

MenuItem SaveGaussMenuData[] = {
  {"Write", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, set_file, "wgauss", NULL},
  {"Append", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, set_file, "agauss", NULL},
EOI};

MenuItem GaussMenuData[] = {
  {"Start Gauss viewer", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, GaussViewer, "open", NULL},
  {"Close Gauss viewer", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, GaussViewer, "close", NULL},
  {"Gaussian mode...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, GaussModeDialog, NULL, NULL},
 MENUSEPARATOR,
  {"Remove Gaussian", &xmCascadeButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, True, NULL, NULL, NULL, RemoveGaussMenuData},
  {"Add Gaussian", &xmPushButtonGadgetClass,
   XK_G, "Alt<Key>G", "Alt+G", False, NULL, new_gaussian, "draw", NULL},
 MENUSEPARATOR,
  {"Fit Gaussians", &xmPushButtonGadgetClass,
   XK_F, "Alt<Key>F", "Alt+F", False, NULL, do_fit, "", NULL},
  {"Fit Gaussians to map spectra", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, FitAllGaussians, "", NULL},
  {"Fit 2-dim Gaussian to map", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, Post2DimFitDialog, NULL, NULL},
 MENUSEPARATOR,
  {"Add selected Gaussians", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, MathSelectedGaussian, "add", NULL},
  {"Add Gaussians to map spectra", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, MathSelectedGaussian, "mapadd", NULL},
  {"Subtract selected Gaussians", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, MathSelectedGaussian, "sub", NULL},
  {"Subtract Gaussians from map spectra", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, MathSelectedGaussian, "mapsub", NULL},
  {"Remove selected Gaussians", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, MathSelectedGaussian, "rem", NULL},
 MENUSEPARATOR,
  {"Read Gaussians from file...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, get_file, "rgauss", NULL},
  {"Save Gaussians to file...", &xmCascadeButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, True, NULL, NULL, NULL, SaveGaussMenuData},
 MENUSEPARATOR,
  {"View Gaussians...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, get_file, "vgauss", NULL},
  {"Sort & View Gaussians...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, get_file, "vsgauss", NULL},
  {"Make all Gaussians markers", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, GaussiansToMarkers, "", NULL},
EOI};


/*** Baseline Menu Items ***/

MenuItem RemoveBaselineBoxMenuData[] = {
  {"All", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, box_reset, "ball", NULL},
  {"Last", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, box_reset, "blatest", NULL},
  {"with cursor", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, box_reset, "bcursor", NULL},
EOI};

MenuItem BaselineMenuData[] = {
  {"Remove baseline box", &xmCascadeButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, True, NULL, NULL, NULL, RemoveBaselineBoxMenuData},
  {"Add baseline box", &xmPushButtonGadgetClass,
   XK_b, "Alt<Key>B", "Alt+B", False, NULL, new_box, "box", NULL},
  {"Edit baseline box with cursor", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, box_reset, "bedit", NULL},
 MENUSEPARATOR,
  {"Set RMS data from boxes", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, SetRmsFromBoxes, "", NULL},
 MENUSEPARATOR,
  {"Reset parameters", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, reset_bl_parameters, "", NULL},
  {"Edit current coefficients", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, EditCurrentBaselineParameters, "", NULL},
 MENUSEPARATOR,
  {"Set polynomial order...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, PolynomialOrderDialog, "", NULL},
  {"Fit baseline", &xmPushButtonGadgetClass,
   XK_f, "Alt<Key>V", "Alt+V", False, NULL, do_baseline_fit, "", NULL},
  {"Subtract polynomial fit", &xmPushButtonGadgetClass,
   XK_VoidSymbol, "Alt<Key>C", "Alt+C", False, NULL, remove_poly, "", NULL},
  {"Add polynomial fit", &xmPushButtonGadgetClass,
   XK_VoidSymbol, "Alt<Key>A", "Alt+A", False, NULL, add_poly, "", NULL},
  {"Interpolate from pol. fit", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, interpolate_from_poly, "", NULL},
 MENUSEPARATOR,
  {"Read boxes from file...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, get_file, "rbox", NULL},
  {"Save boxes to file...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, set_file, "wbox", NULL},
EOI};


/*** Moment Menu Items ***/

MenuItem RemoveMomentBoxMenuData[] = {
  {"All", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, box_reset, "mall", NULL},
  {"Last", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, box_reset, "mlatest", NULL},
  {"with cursor", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, box_reset, "mcursor", NULL},
EOI};

MenuItem RemovePolyLineMenuData[] = {
  {"All", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, MenuDeletePolyLines, "all", NULL},
  {"Last", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, MenuDeletePolyLines, "last", NULL},
EOI};

MenuItem MomentMenuData[] = {
  {"Remove moment box", &xmCascadeButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, True, NULL, NULL, NULL, RemoveMomentBoxMenuData},
  {"Add moment box", &xmPushButtonGadgetClass,
   XK_k, "Alt<Key>M", "Alt+M", False, NULL, new_box, "mom", NULL},
  {"Edit moment box with cursor", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, box_reset, "medit", NULL},
 MENUSEPARATOR,
  {"Remove polyline", &xmCascadeButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, True, NULL, NULL, NULL, RemovePolyLineMenuData},
  {"Create polyline circle...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, PostPolyCircleDialog, "circle", NULL},
EOI};


/*** Marker Menu Items ***/
CallbackData MMD_tagging = {NULL, "tagmarkers", &view.tag_markers, NULL};
CallbackData MMD_join    = {NULL, "joinmarkers", &view.join_markers, NULL};
CallbackData MMD_remove  = {NULL, "removejoint", &view.remove_joint, NULL};

MenuItem RemoveMarkerMenuData[] = {
  {"All", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, mark_reset, "all", NULL},
  {"Last", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, mark_reset, "latest", NULL},
  {"with cursor", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, mark_reset, "rcursor", NULL},
EOI};

MenuItem MarkDopplerFreqFileMenuData[] = {
   {"SLAIM", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, open_freq_file, "dSLAIM", NULL},
   {"Lovas", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, open_freq_file, "dLOVAS", NULL},
   {"JPL", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, open_freq_file, "dJPL", NULL},
EOI};

MenuItem MarkDopplerImageFreqFileMenuData[] = {
   {"SLAIM", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, open_freq_file, "dimSLAIM", NULL},
   {"Lovas", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, open_freq_file, "dimLOVAS", NULL},
   {"JPL", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, open_freq_file, "dimJPL", NULL},
EOI};

MenuItem MarkImageFreqFileMenuData[] = {
   {"SLAIM", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, open_freq_file, "imSLAIM", NULL},
   {"Lovas", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, open_freq_file, "imLOVAS", NULL},
   {"JPL", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, open_freq_file, "imJPL", NULL},
   {"CDMS", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, open_freq_file, "imCDMS", NULL},
EOI};

MenuItem MarkFreqFileMenuData[] = {
   {"SLAIM", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, open_freq_file, "mSLAIM", NULL},
   {"Lovas", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, open_freq_file, "mLOVAS", NULL},
   {"JPL", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, open_freq_file, "mJPL", NULL},
   {"CDMS", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, open_freq_file, "mCDMS", NULL},
   {"Ident", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, open_freq_file, "mIDENT", NULL},
#ifdef SGRIDENT
 MENUSEPARATOR,
   {"SgrB2(M)", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, open_freq_file, "sgrb2m", NULL},
   {"SgrB2(N)", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, open_freq_file, "sgrb2n", NULL},
   {"SgrB2(NW)", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, open_freq_file, "sgrb2nw", NULL},
#endif
#ifdef ORIONIDENT
 MENUSEPARATOR,
   {"Orion", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, open_freq_file, "orion", NULL},
#endif
EOI};

MenuItem ScaleMarkerMenuData[] = {
  {"all markers with 0.5", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, ScaleMarkers, "0.5", NULL},
  {"all markers with 0.9", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, ScaleMarkers, "0.9", NULL},
  {"all markers with 1/0.9", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, ScaleMarkers, "1.1", NULL},
  {"all markers with 2.0", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, ScaleMarkers, "2.0", NULL},
  {"tagged markers with 0.5", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, ScaleMarkers, "t0.5", NULL},
  {"tagged markers with 0.9", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, ScaleMarkers, "t0.9", NULL},
  {"tagged markers with 1/0.9", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, ScaleMarkers, "t1.1", NULL},
  {"tagged markers with 2.0", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, ScaleMarkers, "t2.0", NULL},
EOI};

MenuItem MarkAlignMenuData[] = {
   {"upwards", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, mark_reset, "up", NULL},
   {"centered", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, mark_reset, "center", NULL},
   {"downwards", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, mark_reset, "down", NULL},
EOI};

MenuItem MarkerMenuData[] = {
  {"Remove marker", &xmCascadeButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, True, NULL, NULL, NULL, RemoveMarkerMenuData},
  {"Add new marker with cursor", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, mark_reset, "acursor", NULL},
  {"Edit marker with cursor", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, mark_reset, "ecursor", NULL},
 MENUSEPARATOR,
  {"Open marker file...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, get_file, "rmark", NULL},
  {"Append marker file...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, get_file, "rappmark", NULL},
  {"Save marker file...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, set_file, "wmark", NULL},
 MENUSEPARATOR,
  {"Join two markers", &xmToggleButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, toggle_any, (XtPointer)&MMD_join, NULL},
  {"Remove marker joint", &xmToggleButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, toggle_any, (XtPointer)&MMD_remove, NULL},
 MENUSEPARATOR,
  {"Toggle marker tagging", &xmToggleButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, toggle_any, (XtPointer)&MMD_tagging, NULL},
  {"Untag all markers", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, mark_reset, "untag", NULL},
 MENUSEPARATOR,
  {"Make freq markers", &xmCascadeButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, True, NULL, NULL, NULL, MarkFreqFileMenuData},
  {"Make image freq markers", &xmCascadeButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, True, NULL, NULL, NULL, MarkImageFreqFileMenuData},
  {"Make Doppler corr markers", &xmCascadeButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, True, NULL, NULL, NULL, MarkDopplerFreqFileMenuData},
  /* {"Make Doppler corr image markers", &xmCascadeButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, True, NULL, NULL, NULL, MarkDopplerImageFreqFileMenuData}, */
 MENUSEPARATOR,
  {"Removed tagged markers", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, mark_reset, "rtagged", NULL},
  {"Scale", &xmCascadeButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, True, NULL, NULL, NULL, ScaleMarkerMenuData},
  {"Align tagged markers", &xmCascadeButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, True, NULL, NULL, NULL, MarkAlignMenuData},
EOI};


/*** Reduction Menu Items ***/

MenuItem AverageTypeMenuData[] = {
   {"System temp. & Int. time", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, AverageScans, "A tsys", NULL},
   {"Integration time only", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, AverageScans, "A time", NULL},
   {"RMS box (accum)", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, AverageScans, "A accrms", NULL},
   {"RMS box (add)", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, AverageScans, "A addrms", NULL},
   {"Equal weights", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, AverageScans, "A same", NULL},
EOI};

MenuItem AveragePosTypeMenuData[] = {
   {"System temp. & Int. time", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, AverageScans, "P tsys", NULL},
   {"Integration time only", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, AverageScans, "P time", NULL},
   {"RMS box (accum)", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, AverageScans, "P accrms", NULL},
   {"Equal weights", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, AverageScans, "P same", NULL},
EOI};

MenuItem FFTTypeMenuData[] = {
   {"Forward FFT (Re & Im)", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, do_fft, "cartesian", NULL},
   {"Forward FFT (Ampl. & phase)", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, do_fft, "polar", NULL},
   {"Inverse FFT", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, do_fft, "inverse", NULL},
 MENUSEPARATOR,
   {"Channel correlation", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, do_cor, "", NULL},
   {"Sequence correlation", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, do_cor, "seq", NULL},
EOI};

MenuItem SpeConvolveMenuData[] = {
  {"Use antenna temp. unit", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_spectra, "ConvolveTant", NULL},
  {"Use Jy/beam unit", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_spectra, "ConvolveJansky", NULL},
EOI};

MenuItem ReductionMenuData[] = {
#ifdef MACRO
  {"Edit macro...", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, PostMacroEditDialog, "edit", NULL},
  {"Execute macro", &xmPushButtonGadgetClass,
    XK_VoidSymbol, "Ctrl<Key>E", "Ctrl+E", False, NULL, ExecuteMacro, "menu", NULL},
 MENUSEPARATOR,
#endif
  {"Average all scans", &xmCascadeButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, True, NULL, NULL, NULL, AverageTypeMenuData},
  {"Average scans over positions", &xmCascadeButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, True, NULL, NULL, NULL, AveragePosTypeMenuData},
  {"Join all scans (RMS)", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, AverageScans, "J rms", NULL},
  {"Add all scans", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, AverageScans, "Aadd", NULL},
  {"Subtract scans sequentially", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, AverageScans, "S", NULL},
 MENUSEPARATOR,
  {"Invert scans", &xmPushButtonGadgetClass,
   XK_i, "Alt<Key>I", "Alt+I", False, NULL, invert_scans, "invert", NULL},
  {"Fold scans...", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, FoldSelect, "fold", NULL},
  {"Scale & bias scans...", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, scale_scans, "scale", NULL},
  {"Clip scans...", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, DoClipScans, "clip", NULL},
  {"Smooth scans...", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, smooth_scans, "smooth", NULL},
  {"Redres scans...", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, redres_scans, "smooth", NULL},
 MENUSEPARATOR,
  {"Regrid scans...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_spectra, "Regrid", NULL},
  {"Project cube...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_spectra, "Project", NULL},
  {"Convolve scans...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, NULL, NULL, SpeConvolveMenuData},
 MENUSEPARATOR,
  {"FFT scans", &xmCascadeButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, True, NULL, NULL, NULL, FFTTypeMenuData},
  {"Swap Re&Im or Ampl&Phase", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, swap_spectrum_and_rms, "", NULL},
 MENUSEPARATOR,
  {"Despike spectra...", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, PostDespikeDialog, "despike", NULL},
  {"Remove all modifications", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, mod_reset, "all", NULL},
  {"Remove last modifications", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, mod_reset, "latest", NULL},
  {"Channel modification", &xmPushButtonGadgetClass,
    XK_VoidSymbol, NULL, NULL, False, NULL, channel_mod, "Channel", NULL},
EOI};

/*** Data Menu Items ***/

MenuItem DataSetManipulateMenuData[] = {
  {"Show data set...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_datasets, "Show", NULL},
  {"Rename data set(s)...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_datasets, "Rename", NULL},
  {"Filter data set(s)...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_datasets, "Filter", NULL},
  {"Sequentiate data set(s)...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_datasets, "Seq", NULL},
  {"Unsequentiate data set(s)...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_datasets, "Unseq", NULL},
  {"Merge data sets...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_datasets, "Merge", NULL},
  {"Merge RMS and data scan...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_datasets, "RMSmerge", NULL},
  {"Subtract ref. data set...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_datasets, "Subtract", NULL},
  {"Subtr. & divide ref. data set...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_datasets, "Sub+div", NULL},
 MENUSEPARATOR,
  {"Delete data set(s)...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_datasets, "Delete", NULL},
EOI};

/*** Scan Menu Items ***/

MenuItem ScanManipulateMenuData[] = {
  {"List scans...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_datasets, "ScanList", NULL},
  {"Show scan...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_datasets, "ScanShow", NULL},
  {"Select scan(s)...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_datasets, "ScanSelect", NULL},
  {"Delete scan(s)...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_datasets, "ScanDelete", NULL},
EOI};

MenuItem DataMenuData[] = {
  {"Shift emission velocity...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, PostVLSRDialog, "vshift", NULL},
  {"Set image freq. scale...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, PostImageFreqDialog, "fimshift", NULL},
  {"Swap image freq. scale...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, PostImageFreqDialog, "fimswap", NULL},
  {"Shift x-scale...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, PostShiftDialog, "shift", NULL},
  {"Change velocity scale...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, PostVelShiftDialog, "vshift", NULL},
  {"Change coordinates...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, PostCoordDialog, "change", NULL},
  {"Precess coordinates...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, PostPreDialog, "precess", NULL},
  {"Manipulate scans", &xmCascadeButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, True, NULL, NULL, NULL, ScanManipulateMenuData},
 MENUSEPARATOR,
  {"Attach boxes to data set", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, AttachBoxesToDataset, "attach", NULL},
  {"Detach boxes from data set", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, AttachBoxesToDataset, "deattach", NULL},
 MENUSEPARATOR,
  {"Manipulate data sets", &xmCascadeButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, True, NULL, NULL, NULL, DataSetManipulateMenuData},
 MENUSEPARATOR,
  {"Current data sets", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, get_listlist, SelectDataSet, NULL, NULL},
EOI};

/*** Map Menu Items ***/

MenuItem MapScatterMenuData[] = {
  {"Use radial distance as x-unit", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, ViewCurrentMapAsScatterPlot, "Distance", NULL},
  {"Use x-axis as x-unit", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, ViewCurrentMapAsScatterPlot, "x-axis", NULL},
  {"Use y-axis as x-unit", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, ViewCurrentMapAsScatterPlot, "y-axis", NULL},
  {"Use position angle as x-unit", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, ViewCurrentMapAsScatterPlot, "PosAngle", NULL},
  {"Use distance along polyline", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, ViewCurrentMapAsScatterPlot, "PolyLine", NULL},
EOI};

MenuItem MapConvolveMenuData[] = {
  {"Use antenna temp. unit", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_maps, "ConvolveTant", NULL},
  {"Use Jy/beam unit", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_maps, "ConvolveJansky", NULL},
EOI};

MenuItem MapBlankMenuData[] = {
  {"Blank data < 3sigma in map(s)...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_maps, "Blank", NULL},
  {"Unblank data < 3sigma in map(s)...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_maps, "Unblank", NULL},
 MENUSEPARATOR,
  {"Blank pixels inside polylines", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_maps, "BlankInside", NULL},
  {"Unblank pixels inside polylines", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_maps, "UnblankInside", NULL},
 MENUSEPARATOR,
  {"Blank pixels outside polylines", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_maps, "BlankOutside", NULL},
  {"Unblank pixels outside polylines", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_maps, "UnblankOutside", NULL},
EOI};

MenuItem MapAveMenuData[] = {
  {"Avg in x-dir inside polylines in map(s)...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_maps, "AveXinside", NULL},
  {"Avg in y-dir inside polylines in map(s)...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_maps, "AveYinside", NULL},
  {"Avg in x-dir outside polylines in map(s)...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_maps, "AveXoutside", NULL},
  {"Avg in y-dir outside polylines in map(s)...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_maps, "AveYoutside", NULL},
EOI};

MenuItem MapManipulateMenuData[] = {
  {"Show map(s)...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_maps, "Show", NULL},
  {"Show two maps overlayed...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_maps, "Overlay", NULL},
  {"Rename map(s)...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_maps, "Rename", NULL},
  {"Copy map(s)...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_maps, "Copy", NULL},
  {"Change map(s)...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_maps, "Change", NULL},
  {"Combine two maps...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_maps, "Combine", NULL},
  {"Precess map(s)...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_maps, "Precess", NULL},
  {"Blank & unblank data", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, NULL, NULL, MapBlankMenuData},
  {"Swap data & error in map(s)...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_maps, "Swap", NULL},
  {"FFT shift data in map(s)...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_maps, "Shift", NULL},
  {"Forward FFT of map(s)...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_maps, "FFT", NULL},
  {"Inverse FFT of map(s)...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_maps, "iFFT", NULL},
#ifdef APEX
  {"Holo correct data in map(s)...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_maps, "NearF", NULL},
  {"Holo fit phase data in map(s)...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_maps, "HoloF", NULL},
#endif
  {"Replace data with S/N in map(s)...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_maps, "S/N", NULL},
  {"Merge data and error maps...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_maps, "Merge", NULL},
  {"Edit beam in map...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_maps, "Edit beam", NULL},
  {"Average maps in one dimension", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, NULL, NULL, MapAveMenuData},
  {"Scale map...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_maps, "Scale", NULL},
  {"Interpolate map...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_maps, "Interpolate", NULL},
  {"Regrid map...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_maps, "Regrid", NULL},
  {"Convolve map...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, NULL, NULL, MapConvolveMenuData},
  {"Correlate map...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_maps, "Correlate", NULL},
  {"MEM map...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_maps, "MEM", NULL},
  {"Map arithmetic...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_maps, "Arithmetic", NULL},
 MENUSEPARATOR,
  {"Delete map(s)...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_maps, "Delete", NULL},
EOI};

MenuItem MapsMenuData[] = {
  {"Store current map...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, store_current_map, "store", NULL},
  {"Store multiple maps...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, StoreMultipleMaps, "store", NULL},
  {"Create a test map...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, PostTestMapDialog, "", NULL},
  {"Save maps as FITS cube...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_maps, "Cube", NULL},
  {"View current map as scatter plot", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, NULL, NULL, MapScatterMenuData},
 MENUSEPARATOR,
  {"Attach contour/grey data to map", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, AttachContToMap, "attach", NULL},
  {"Detach contour/grey data from map", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, AttachContToMap, "deattach", NULL},
 MENUSEPARATOR,
  {"Manipulate maps", &xmCascadeButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, True, NULL, NULL, NULL, MapManipulateMenuData},
 MENUSEPARATOR,
  {"Current maps", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, get_maplist, MapDraw, NULL, NULL},
EOI};


/*** Scatter Menu Items ***/
CallbackData SMD_tagging = {NULL, "tagscatterpts", &view.tag_scatters, NULL};

MenuItem ScatterTaggedMenuData[] = {
  {"Unselect all points", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, ScatterPointOps, "untag", NULL},
  {"Invert selection", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, ScatterPointOps, "invert", NULL},
 MENUSEPARATOR,
  {"New plot of selected points", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, ScatterPointOps, "select_tagged", NULL},
  {"New plot of unselected points", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, ScatterPointOps, "select_untagged", NULL},
 MENUSEPARATOR,
  {"New seq scans of selected points", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, ScatterPointOps, "select_tagged_as_scans", NULL},
  {"New seq scans of unselected points", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, ScatterPointOps, "select_untagged_as_scans", NULL},
 MENUSEPARATOR,
  {"New MJD seq scans of selected points", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, ScatterPointOps, "select_tagged_as_MJDscans", NULL},
  {"New MJD seq scans of unselected points", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, ScatterPointOps, "select_untagged_as_MJDscans", NULL},
EOI};

MenuItem ScatterManipulateMenuData[] = {
  {"Show plots(s)...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_scats, "Show", NULL},
  {"Rename plots(s)...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_scats, "Rename", NULL},
  {"Copy plot(s)...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_scats, "Copy", NULL},
  {"Swap x & y in plot(s)...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_scats, "Swap", NULL},
  {"Sort x in plot(s)...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_scats, "Sort", NULL},
  {"Scale plot(s)...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_scats, "Scale", NULL},
  {"Invert y-scale in plot(s)...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_scats, "InvertY", NULL},
  {"Bin plot(s)...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_scats, "Bin", NULL},
  {"Merge & clip plot(s)...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_scats, "Merge", NULL},
  {"Calculate Allan variance of plot(s)...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_scats, "Allan", NULL},
  {"Derive plot(s)...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_scats, "d/dx", NULL},
  {"Forward FFT of plot(s)...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_scats, "FFT", NULL},
  /* {"Inverse FFT of plot(s)...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_scats, "iFFT", NULL}, */
  {"Logarithm of plot(s)...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_scats, "Log", NULL},
  {"Plot arithmetic...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_scats, "Arithmetic", NULL},
 MENUSEPARATOR,
  {"Make pointing residuals of plot(s)...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_scats, "poires", NULL},
 MENUSEPARATOR,
  {"Delete plot(s)...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, manipulate_scats, "Delete", NULL},
EOI};

MenuItem ScatterMenuData[] = {
  {"Store current scatter plot...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, StoreCurrentScatter, "store", NULL},
  {"View current spectrum as scatter plot...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, MakeSingleSpeScatterPlot, "single", NULL},
  {"View current spectra as scatter plot...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, PostScatterTypeDialog, NULL, NULL},
  {"Set scatter plot options...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, PostScatterOptionDialog, "post", NULL},
 MENUSEPARATOR,
  {"Select scatter points", &xmToggleButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, toggle_any, (XtPointer)&SMD_tagging, NULL},
  {"Operate on sel. points", &xmCascadeButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, True, NULL, NULL, NULL, ScatterTaggedMenuData},
 MENUSEPARATOR,
  {"Manipulate scatter plots", &xmCascadeButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, True, NULL, NULL, NULL, ScatterManipulateMenuData},
 MENUSEPARATOR,
  {"Current scatter plot", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, get_scatterlist, ScatterDraw, NULL, NULL},
EOI};


/*** Preferences Menu Items ***/

MenuItem EditPrefsMenuData[] = {
  {"Data files...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, EditPrefsFile, "DataPrefs", NULL},
  {"Unix cmds...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, EditPrefsFile, "UnixPrefs", NULL},
  {"Freq. files...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, EditPrefsFile, "FreqfilePrefs", NULL},
  {"Window sizes...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, EditPrefsFile, "WindowPrefs", NULL},
  {"Astronomical info...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, EditPrefsFile, "AstroPrefs", NULL},
  {"Other prefs...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, EditPrefsFile, "OtherPrefs", NULL},
#ifdef APEX
  {"Holographic data setup...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, EditHoloData,  "HoloSetup", NULL},
  {"Holographic fit setup...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, EditHoloFit,   "HoloSetup", NULL},
  {"APEX map setup...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, EditAPEXMap,   "MapSetup", NULL},
#endif
EOI};

MenuItem PrefsMenuData[] = {
  {"View preferences in ~/.xsrc...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, ViewPrefsFile, "view", NULL},
  {"Edit preferences", &xmCascadeButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, True, NULL, NULL, NULL, EditPrefsMenuData},
 MENUSEPARATOR,
  {"Save preferences", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, MenuSavePrefsFile, "store", NULL},
EOI};


/*** Help Menu Items ***/

MenuItem HelpMenuData[] = {
  {"Mouse buttons...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, Help, "MouseButtons", NULL},
  {"Keyboard accelerators...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, Help, "AccelKeys", NULL},
 MENUSEPARATOR,
  {"File menu...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, Help, "FileMenu", NULL},
  {"Graph menu...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, Help, "GraphMenu", NULL},
  {"Gauss menu...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, Help, "GaussMenu", NULL},
  {"Baseline menu...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, Help, "BaselineMenu", NULL},
  {"Moment menu...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, Help, "MomentMenu", NULL},
  {"Marker menu...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, Help, "MarkerMenu", NULL},
  {"Reduction menu...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, Help, "ReductionMenu", NULL},
  {"Data sets menu...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, Help, "DatasetsMenu", NULL},
  {"Maps menu...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, Help, "MapsMenu", NULL},
  {"Scatter menu...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, Help, "ScatterMenu", NULL},
  {"Prefs menu...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, Help, "PrefsMenu", NULL},
  {"Help menu...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, Help, "HelpMenu", NULL},
 MENUSEPARATOR,
  {"About...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, About, "", NULL},
  {"Version...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, Version, "", NULL},
  {"License...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, ReadMe, "", NULL},
 MENUSEPARATOR,
  {"What's new...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, WhatsNew, "", NULL},
  {"Problems & bugs...", &xmPushButtonGadgetClass,
   XK_VoidSymbol, NULL, NULL, False, NULL, ProblemsAndBugs, "", NULL},
EOI};


/*** Menu-Bar Items ***/

MenuBarItem MenuBarData[] = {
  {"File",      XK_F, True, FileMenuData},
  {"Graph",     XK_G, True, GraphMenuData},
  {"Gauss",     XK_a, True, GaussMenuData},
  {"Baseline",  XK_B, True, BaselineMenuData},
  {"Moment",    XK_M, True, MomentMenuData},
  {"Marker",    XK_r, True, MarkerMenuData},
  {"Reduction", XK_R, True, ReductionMenuData},
  {"Data sets", XK_D, True, DataMenuData},
  {"Maps",      XK_p, True, MapsMenuData},
  {"Scatter",   XK_S, True, ScatterMenuData},
  {"Prefs",     XK_s, True, PrefsMenuData},
  {"Help",      XK_H, True, HelpMenuData},
EOI};
